<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

// Add the child theme installer section to your dashboard
add_action('admin_init', 'gt3_child_theme_installer_init');

function gt3_child_theme_installer_init() {
	// Enqueue scripts only on your dashboard page
	add_action('admin_enqueue_scripts', 'gt3_child_theme_installer_scripts');

	// Register AJAX handlers
	add_action('wp_ajax_gt3_install_child_theme', 'gt3_install_child_theme_ajax');
	add_action('wp_ajax_gt3_activate_child_theme', 'gt3_activate_child_theme_ajax');
}

function gt3_child_theme_installer_scripts($hook) {
	// Only load on your dashboard page
	if ($hook !== 'toplevel_page_gt3_dashboard' && $hook !== 'admin_page_gt3_dashboard') {
		return;
	}

	wp_enqueue_script('gt3-child-theme-installer', get_template_directory_uri() . '/js/child-theme-installer.js', array('jquery'), '1.0', true);
	wp_localize_script('gt3-child-theme-installer', 'gt3ChildTheme', array(
		'ajax_url' => admin_url('admin-ajax.php'),
		'nonce' => wp_create_nonce('gt3_child_theme_nonce'),
		'redirect_url' => admin_url('admin.php?page=gt3_dashboard')
	));

	// Add inline CSS
	add_action('admin_head', 'gt3_child_theme_installer_css');
}

function gt3_child_theme_installer_css() {
	?>
	<style>
		.gt3-child-theme-installer h3 {
			margin: 0 0 10px 0 !important;
			color: #495057;
			font-family: Rubik;
			font-weight: 500;
			font-size: 20px !important;
			position: relative;
			display: inline-block;
		}
		.gt3-child-theme-installer h3 + p {
			margin-bottom: 24px !important;
		}
		.gt3-child-theme-installer .gt3-label {
			position: absolute;
			font-size: 11px;
			color: #f46a6a;
			left: calc(100% + 7px);
			top: 0;
		}
		.gt3-themes-wrapper {
			display: flex;
			flex-wrap: wrap;
			gap: 20px;
		}
		.gt3-theme-item {
			flex: 0 0 32%;
			max-width: 32%;
			box-sizing: border-box;
		}
		.gt3-theme-item img {
			width: 100%;
			max-width: 100%;
			height: auto;
		}
		.gt3-theme-title {
			font-size: 18px;
			line-height: 1.5;
			padding: 18px 0 6px 0;
			font-family: Rubik;
			font-weight: 500;
			color: #495057;
		}
		.gt3-theme-btns {
			display: flex;
			gap: 10px;
			margin-bottom: 12px;
		}
		.gt3-theme-btns button {
			flex: 1;
			text-align: center;
			padding: 9px 12px;
			color: #fff;
			border: none;
			border-radius: 4px !important;
			cursor: pointer;
			transition: background 0.3s;
			font-size: 14px;
			height: auto;
			line-height: 1.5;
		}
		.gt3-install-btn {
			background: #f46a6a;
		}
		.gt3-install-btn:hover {
			background: #f34d4d;
		}
		.gt3-view-btn {
			background: #556ee6;
		}
		.gt3-view-btn:hover {
			background: #485ec4;
		}

		.gt3-progress-container {
			display: none;
			margin-top: 15px;
		}
		.gt3-progress-bar {
			width: 100%;
			height: 12px;
			background: #f6f6f6;
			border-radius: 2px;
			/*overflow: hidden;*/
			position: relative;
		}
		.gt3-progress-fill {
			height: 100%;
			background-image: linear-gradient(45deg,hsla(0,0%,100%,.15) 25%,transparent 0,transparent 50%,hsla(0,0%,100%,.15) 0,hsla(0,0%,100%,.15) 75%,transparent 0,transparent);
			background-color: #556ee6;
			width: 0%;
			transition: width 0.3s ease;
			display: flex;
			align-items: center;
			justify-content: center;
			color: #fff;
			font-size: 11px;
			font-weight: 600;
			border-radius: 2px;
			background-size: 0.625rem 0.625rem;
			animation: progress-bar-stripes 1s linear infinite;
		}
		@keyframes progress-bar-stripes{
			0%{
				background-position-x:.625rem
			}
		}
		.gt3-progress-message {
			margin-top: 10px;
			font-size: 13px;
			color: #495057;
		}
		/*.gt3-success-message {
			color: #34c38f;
		}
		.gt3-error-message {
			color: red;
		}*/
	</style>
	<?php
}

// Render the installer UI (add this to your dashboard page)
function gt3_render_child_theme_installer() {
	ob_start();
	$child_theme_slug = 'ewebotbento';
	$child_theme_status = gt3_get_child_theme_status($child_theme_slug);

	?>
	<div class="gt3-child-theme-installer">
		<h3>Starter Templates<span class="gt3-label">NEW</span></h3>
		<p>This feature lets you import demo content for starter templates, each with a predefined design and a set of inner pages.</p>
		<div class="gt3-themes-wrapper">
			<div class="gt3-theme-item">
				<img src="<?php echo get_template_directory_uri(); ?>/core/admin/img/bento.jpg" alt="Bento Theme">
				<div class="gt3-theme-title">Bento</div>
				<p>A modern, bento-style template for agencies and freelancers, featuring bold visuals and clean layouts to showcase your projects.</p>
				<div class="gt3-theme-btns">
					<?php if ($child_theme_status === 'installed'): ?>
						<button class="gt3-install-btn" id="gt3-activate-child-theme">Activate Theme</button>
					<?php else: ?>
						<button class="gt3-install-btn" id="gt3-install-child-theme">Install Theme</button>
					<?php endif; ?>
					<button class="gt3-view-btn" onclick="window.open('https://ewebot.livewp.site/bento/', '_blank')">View Theme</button>
				</div>
				<div class="gt3-progress-container" id="gt3-progress-container">
					<div class="gt3-progress-bar">
						<div class="gt3-progress-fill" id="gt3-progress-fill">0%</div>
					</div>
					<div class="gt3-progress-message" id="gt3-progress-message"></div>
				</div>
			</div>
		</div>
	</div>
	<?php

	$render = trim(ob_get_clean());

	return !empty($render) ? $render : '';
}

// Check child theme status
function gt3_get_child_theme_status($theme_slug) {
	$theme = wp_get_theme($theme_slug);

	if ($theme->exists()) {
		$current_theme = wp_get_theme();
		if ($current_theme->get_stylesheet() === $theme_slug) {
			return 'active';
		}
		return 'installed';
	}

	return 'not_installed';
}

// AJAX handler for installing child theme
function gt3_install_child_theme_ajax() {
	check_ajax_referer('gt3_child_theme_nonce', 'nonce');

	if (!current_user_can('install_themes')) {
		wp_send_json_error(array('message' => 'You do not have permission to install themes.'));
	}

	// Clean all output buffers to prevent JSON parsing errors
	while (ob_get_level() > 0) {
		ob_end_clean();
	}
	ob_start();

	// Include required WordPress files
	require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
	require_once ABSPATH . 'wp-admin/includes/theme.php';
	require_once ABSPATH . 'wp-admin/includes/file.php';
	require_once ABSPATH . 'wp-admin/includes/misc.php';

	$download_url = 'http://gt3accounts.com/update/tgm.php?eyJhIjoiZG93bmxvYWRfY2hpbGQiLCJzIjoiZXdlYm90YmVudG8ifQ==';

	// Create a custom silent skin that suppresses all output
	class GT3_Silent_Upgrader_Skin extends WP_Upgrader_Skin {
		public function header() {}
		public function footer() {}
		public function feedback($string, ...$args) {}
		public function before() {}
		public function after() {}
		public function error($errors) {}
	}

	$skin = new GT3_Silent_Upgrader_Skin();
	$upgrader = new Theme_Upgrader($skin);

	// Disable maintenance mode
	add_filter('upgrader_package_options', function($options) {
		$options['abort_if_destination_exists'] = false;
		return $options;
	});

	$result = $upgrader->install($download_url);

	// Clear any output that may have been generated
	ob_end_clean();

	if (is_wp_error($result)) {
		wp_send_json_error(array('message' => $result->get_error_message()));
	}

	if ($result === false) {
		wp_send_json_error(array('message' => 'Installation failed. Please try again.'));
	}

	// Get the installed theme slug
	$theme_info = $upgrader->theme_info();
	if ($theme_info) {
		wp_send_json_success(array(
			'message' => 'Child theme installed successfully!',
			'theme_slug' => $theme_info->get_stylesheet()
		));
	}

	wp_send_json_success(array('message' => 'Child theme installed successfully!'));
}

// AJAX handler for activating child theme
function gt3_activate_child_theme_ajax() {
	check_ajax_referer('gt3_child_theme_nonce', 'nonce');

	if (!current_user_can('switch_themes')) {
		wp_send_json_error(array('message' => 'You do not have permission to activate themes.'));
	}

	$theme_slug = 'ewebotbento';
	$theme = wp_get_theme($theme_slug);

	if (!$theme->exists()) {
		wp_send_json_error(array('message' => 'Child theme not found. Please install it first.'));
	}

	switch_theme($theme_slug);

	wp_send_json_success(array('message' => 'Child theme activated successfully!'));
}

add_filter('gt3_rest_get_settings', function($args){
	$args['activeChildData'] = gt3_render_child_theme_installer();
	return $args;
});
