<?php

if(!defined('ABSPATH')) {
	exit;
}

use Elementor\Utils;

/** @var \ElementorModal\Widgets\GT3_Core_Elementor_Widget_TextSlider $widget */


$settings = array(
	'interval'      => 3000,
	'speed'         => 600,
	'autoplay'      => 'yes',
);

$settings = wp_parse_args($this->get_settings(), $settings);

$options = array(
	'type' => 'loop',
	'autoWidth' => true,
	'perPage' => 1,
	'gap' => '20px',
	'pauseOnHover' => false,
	'pauseOnFocus' => false,
	'resetProgress' => false,
	'arrows' => false,
	'pagination' => false,
	'interval' => intval( $settings['interval'] ?? 3000 ),
	'speed'    => intval( $settings['speed'] ?? 600 ),
	'autoplay' => !empty($settings['autoplay']),
	'drag' => empty($settings['autoplay']),
);

$this->add_render_attribute('wrapper', 'class', 'gt3-text-slider');

$data_attr = esc_attr( wp_json_encode( $options ) );

$settings = $widget->get_settings_for_display();

$textColor = !empty($settings['text_color']) ? $settings['text_color'] : '#E2E6EA';
$textActive = !empty($settings['text_color_active']) ? $settings['text_color_active'] : '#062B3E';
$gradientStart = !empty($settings['textgradient_start']) ? $settings['textgradient_start'] : '#D796FF';
$gradientEnd = !empty($settings['textgradient_end']) ? $settings['textgradient_end'] : '#2683F4';

$this->add_render_attribute('wrapper', 'data-color', esc_attr($textColor));
$this->add_render_attribute('wrapper', 'data-color-active', esc_attr($textActive));
if ($settings['enable_theme_textgradient'] !== '') {
	$this->add_render_attribute('wrapper', 'data-gradient', 'linear-gradient(360deg, '.esc_attr($gradientStart).' 13.41%, '.esc_attr($gradientEnd).' 151.83%)');
}

?>
	<div <?php $this->print_render_attribute_string('wrapper') ?>>
		<?php
			if(is_array($settings['text']) && count($settings['text'])) {
				echo '<div class="container"><div class="splide" data-splide="'.$data_attr.'"><div class="splide__track"><ul class="splide__list">';
				foreach($settings['text'] as $text) {
					echo '<li class="splide__slide"><span class="gt3-text-slider-title">' . $text['string'] . '</span></li>';
				}
				echo '</ul></div></div></div>';
			}
		?>
	</div>
<?php


