<?php

if(!defined('ABSPATH')) {
	exit;
}

use Elementor\Controls_Manager;
use GT3\ThemesCore\Elementor\Controls\Query;
use Elementor\Group_Control_Typography;

/** @var \ElementorModal\Widgets\GT3_Core_Elementor_Widget_PortfolioCarousel $widget */

$widget->start_controls_section(
	'query',
	array(
		'label' => esc_html__('Query', 'gt3_themes_core'),
	)
);
$widget->add_control(
	'query',
	array(
		'label'       => esc_html__('Query', 'gt3_themes_core'),
		'type'        => Query::type(),
		'settings'    => array(
			'showCategory'  => true,
			'showUser'      => true,
			'showPost'      => true,
			'post_type'     => $widget->POST_TYPE,
			'post_taxonomy' => $widget->TAXONOMY,
		),
	)
);

$widget->end_controls_section();

$widget->start_controls_section(
	'section',
	array(
		'label' => esc_html__('Main Settings', 'gt3_themes_core'),
		'tab'   => Controls_Manager::TAB_SETTINGS,
	)
);

$widget->add_control(
	'orientation',
	array(
		'label'   => esc_html__('Carousel Orientation', 'gt3_themes_core'),
		'type'    => Controls_Manager::SELECT,
		'options' => array(
			'horizontal'   => esc_html__('Horizontal', 'gt3_themes_core'),
			'vertical' => esc_html__('Vertical', 'gt3_themes_core'),
		),
		'default' => 'horizontal',
		'prefix_class' => 'gt3-orientation-',
	)
);

$widget->add_responsive_control(
	'height',
	array(
		'label'     => esc_html__('Height (% of window height)', 'gt3_themes_core'),
		'type'      => Controls_Manager::SELECT,
		'options'   => array(
			'30'  => esc_html__('30%', 'gt3_themes_core'),
			'35'  => esc_html__('35%', 'gt3_themes_core'),
			'40'  => esc_html__('40%', 'gt3_themes_core'),
			'45'  => esc_html__('45%', 'gt3_themes_core'),
			'50'  => esc_html__('50%', 'gt3_themes_core'),
			'55'  => esc_html__('55%', 'gt3_themes_core'),
			'60'  => esc_html__('60%', 'gt3_themes_core'),
			'65'  => esc_html__('65%', 'gt3_themes_core'),
			'70'  => esc_html__('70%', 'gt3_themes_core'),
			'75'  => esc_html__('75%', 'gt3_themes_core'),
			'80'  => esc_html__('80%', 'gt3_themes_core'),
			'85'  => esc_html__('85%', 'gt3_themes_core'),
			'90'  => esc_html__('90%', 'gt3_themes_core'),
			'95'  => esc_html__('95%', 'gt3_themes_core'),
			'100' => esc_html__('100%', 'gt3_themes_core'),
		),
		'default'   => '100',
		'condition'  => array(
			'orientation' => 'vertical',
		),
		'selectors' => array(
			'{{WRAPPER}}.gt3-orientation-vertical' => '--module_height: {{VALUE}}vh;',
		),
	)
);

$widget->add_responsive_control(
	'padding',
	array(
		'label'     => esc_html__('Padding (top/bottom), %', 'gt3_themes_core'),
		'type'      => Controls_Manager::SELECT,
		'options'   => array(
			'0'  => esc_html__('0%', 'gt3_themes_core'),
			'5'  => esc_html__('5%', 'gt3_themes_core'),
			'10'  => esc_html__('10%', 'gt3_themes_core'),
			'15'  => esc_html__('15%', 'gt3_themes_core'),
			'20'  => esc_html__('20%', 'gt3_themes_core'),
			'25'  => esc_html__('25%', 'gt3_themes_core'),
			'30'  => esc_html__('30%', 'gt3_themes_core'),
		),
		'default'   => '15',
		'condition'  => array(
			'orientation' => 'vertical',
		),
		'selectors' => array(
			'{{WRAPPER}}.gt3-orientation-vertical' => '--module_padding: {{VALUE}};',
		),
	)
);

$widget->add_control(
	'nav',
	array(
		'label'   => esc_html__('Navigation', 'gt3_themes_core'),
		'type'    => Controls_Manager::SELECT,
		'options' => array(
			'none'   => esc_html__('None', 'gt3_themes_core'),
			'arrows' => esc_html__('Arrows', 'gt3_themes_core'),
			'dots'   => esc_html__('Dots', 'gt3_themes_core'),
		),
		'default' => 'arrows',
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_control(
	'items_per_line',
	array(
		'label'   => esc_html__('Items Per Line', 'gt3_themes_core'),
		'type'    => Controls_Manager::SELECT,
		'options' => array(
			'1'   => esc_html__('1', 'gt3_themes_core'),
			'2'   => esc_html__('2', 'gt3_themes_core'),
			'3'   => esc_html__('3', 'gt3_themes_core'),
			'4'   => esc_html__('4', 'gt3_themes_core'),
		),
		'default' => '1',
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_control(
	'autoplay',
	array(
		'label' => esc_html__('Autoplay', 'gt3_themes_core'),
		'type'  => Controls_Manager::SWITCHER,
	)
);

$widget->add_control(
	'autoplay_time',
	array(
		'label'     => esc_html__('Autoplay time', 'gt3_themes_core'),
		'type'      => Controls_Manager::NUMBER,
		'default'   => 4000,
		'min'       => '0',
		'step'      => 100,
		'condition' => array(
			'autoplay' => 'yes'
		),
	)
);

$widget->add_control(
	'center_mode',
	array(
		'label' => esc_html__('Center Mode', 'gt3_themes_core'),
		'type'  => Controls_Manager::SWITCHER,
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_responsive_control(
	'space',
	array(
		'label'     => esc_html__('Space Between Items', 'gt3_themes_core'),
		'type'      => Controls_Manager::SELECT,
		'options'   => array(
			'0px'     => '0',
			'1px'   => '1px',
			'2px'   => '2px',
			'3px'   => '3px',
			'4px'   => '4px',
			'5px'   => '5px',
			'10px'  => '10px',
			'15px'  => '15px',
			'20px'  => '20px',
			'25px'  => '25px',
			'30px'  => '30px',
			'35px'  => '35px',
			'40px'  => '40px',
			'50px'  => '50px',
			'60px'  => '60px',
		),
		'default'   => '60px',
		'selectors' => array(
			'{{WRAPPER}} .items_list' => 'margin-right:-{{VALUE}};',
			'{{WRAPPER}} .portfolio_item' => 'padding-right:{{VALUE}};',
			'{{WRAPPER}} .portfolio_carousel_wrapper .slick-arrow.slick-next' => '
    margin-right: {{VALUE}};',
			'{{WRAPPER}} .portfolio_carousel_wrapper div.slick-slider ul.slick-dots' => '
    margin-right: {{VALUE}};',
			'{{WRAPPER}}.gt3-orientation-vertical' => '--item_spacing: {{VALUE}};',
		)
	)
);


$widget->add_control(
	'show_title',
	array(
		'label' => esc_html__('Show Title', 'gt3_themes_core'),
		'type'  => Controls_Manager::SWITCHER,
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_control(
	'show_category',
	array(
		'label' => esc_html__('Show Category', 'gt3_themes_core'),
		'type'  => Controls_Manager::SWITCHER,
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_control(
	'show_text',
	array(
		'label' => esc_html__('Show Text', 'gt3_themes_core'),
		'type'  => Controls_Manager::SWITCHER,
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_control(
	'portfolio_btn_link',
	array(
		'label'   => esc_html__( 'Show "Read More" button?', 'gt3_themes_core' ),
		'type'    => Controls_Manager::SWITCHER,
		'default' => '',
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_control(
	'portfolio_btn_link_title',
	array(
		'label'     => esc_html__('"Read More" Button Title', 'gt3_themes_core'),
		'type'      => Controls_Manager::TEXT,
		'default'   => esc_html__('Read More', 'gt3_themes_core'),
		'condition' => array(
			'portfolio_btn_link!' => '',
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_control(
	'item_align',
	array(
		'label'   => esc_html__('Alignment', 'gt3_themes_core'),
		'type'    => Controls_Manager::CHOOSE,
		'options' => array(
			'left'   => array(
				'title' => esc_html__('Left', 'gt3_themes_core'),
				'icon'  => 'eicon-text-align-left',
			),
			'center' => array(
				'title' => esc_html__('Center', 'gt3_themes_core'),
				'icon'  => 'eicon-text-align-center',
			),
			'right'  => array(
				'title' => esc_html__('Right', 'gt3_themes_core'),
				'icon'  => 'eicon-text-align-right',
			),
		),
		'label_block' => false,
		'prefix_class' => 'text_align-',
		'condition'  => array(
			'orientation' => 'horizontal',
		),
	)
);

$widget->add_group_control(
	Group_Control_Typography::get_type(),
	array(
		'name'      => 'title_typography',
		'label'     => esc_html__('Title Typography', 'gt3_themes_core'),
		'condition'  => array(
			'orientation' => 'vertical',
		),
		'selector'  => '{{WRAPPER}}.gt3-orientation-vertical .items_nav .title, {{WRAPPER}}.gt3-orientation-vertical .gt3_vertical_carousel_wrapper .items_list.slick-vertical .portfolio_item .text_wrap .title',
	)
);

$widget->add_control(
	'title_color',
	array(
		'label'       => esc_html__('Title Color', 'gt3_themes_core'),
		'type'        => Controls_Manager::COLOR,
		'condition'  => array(
			'orientation' => 'vertical',
		),
		'selectors'   => array(
			'{{WRAPPER}}.gt3-orientation-vertical .items_nav .title' => 'color: {{VALUE}};',
		),
	)
);

$widget->add_control(
	'title_color_active',
	array(
		'label'       => esc_html__('Title Color (Active)', 'gt3_themes_core'),
		'type'        => Controls_Manager::COLOR,
		'condition'  => array(
			'orientation' => 'vertical',
		),
		'selectors'   => array(
			'{{WRAPPER}}.gt3-orientation-vertical .items_nav .title.slick-current, {{WRAPPER}}.gt3-orientation-vertical .items_nav .title:hover' => 'color: {{VALUE}};',
		),
	)
);

$widget->add_control(
	'show_category_vertical',
	array(
		'label' => esc_html__('Show Category', 'gt3_themes_core'),
		'type'  => Controls_Manager::SWITCHER,
		'condition'  => array(
			'orientation' => 'vertical',
		),
		'prefix_class' => 'gt3-vertical-category-',
	)
);

$widget->add_control(
	'alignment_vertical',
	array(
		'label'   => esc_html__('Alignment', 'gt3_themes_core'),
		'type'    => Controls_Manager::CHOOSE,
		'options' => array(
			'top'   => array(
				'title' => esc_html__('Top', 'gt3_themes_core'),
				'icon'  => 'eicon-v-align-top',
			),
			'middle' => array(
				'title' => esc_html__('Center', 'gt3_themes_core'),
				'icon'  => 'eicon-v-align-middle',
			),
			'bottom'  => array(
				'title' => esc_html__('Bottom', 'gt3_themes_core'),
				'icon'  => 'eicon-v-align-bottom',
			),
		),
		'label_block' => false,
		'prefix_class' => 'vertical_align-',
		'condition'  => array(
			'orientation' => 'vertical',
		),
		'default'   => 'bottom',
	)
);

$widget->end_controls_section();


