<?php

if(!defined('ABSPATH')) {
	exit;
}

use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

/** @var \ElementorModal\Widgets\GT3_Core_Elementor_Widget_ImageAccordion $widget */

$widget->start_controls_section(
	'items',
	array(
		'label' => esc_html__('Items', 'gt3_themes_core'),
		'tab'   => Controls_Manager::TAB_CONTENT,
	)
);

$widget->add_control(
	'items',
	array(
		'label'       => esc_html__('Items', 'gt3_themes_core'),
		'type'        => Controls_Manager::REPEATER,
		'default'     => array(),
		'fields'      => $widget->get_repeater_fields(),
		'title_field' => '{{{ title }}}',
	)
);

$widget->end_controls_section();

$widget->start_controls_section(
	'section_style_accordions',
	array(
		'label' => __('Content', 'gt3_themes_core'),
		'tab'   => Controls_Manager::TAB_STYLE,
	)
);

$widget->add_group_control(
	Group_Control_Typography::get_type(),
	array(
		'name'      => 'title_typography',
		'label'     => esc_html__('Title Typography', 'gt3_themes_core'),
		'selector'  => '{{WRAPPER}} .gt3-accordion-wrapper .gt3-accordion-item .gt3-accordion-inner-wrap .gt3-accordion-wrapper-title, {{WRAPPER}} .gt3-accordion-wrapper .gt3-accordion-item .gt3-accordion-title',
	)
);

$widget->add_control(
	'color_title',
	array(
		'label'     => esc_html__('Title Color', 'gt3_themes_core'),
		'type'      => Controls_Manager::COLOR,
		'selectors' => array(
			'{{WRAPPER}} .gt3-accordion-wrapper .gt3-accordion-item .gt3-accordion-inner-wrap .gt3-accordion-wrapper-title' => 'color: {{VALUE}};',
		),
	)
);

$widget->add_group_control(
	Group_Control_Typography::get_type(),
	array(
		'name'      => 'content_typography',
		'label'     => esc_html__('Content Typography', 'gt3_themes_core'),
		'selector'  => '{{WRAPPER}} .gt3-accordion-wrapper .gt3-accordion-item .gt3-accordion-inner-wrap .gt3-accordion-text',
	)
);

$widget->add_control(
	'color_description',
	array(
		'label'     => esc_html__('Content Color', 'gt3_themes_core'),
		'type'      => Controls_Manager::COLOR,
		'selectors' => array(
			'{{WRAPPER}} .gt3-accordion-wrapper .gt3-accordion-item .gt3-accordion-inner-wrap .gt3-accordion-text' => 'color: {{VALUE}};',
		),
	)
);

$widget->end_controls_section();
