# Security Practices

Security guidelines and patterns for Duplicator Pro.

## Input Validation

**Use SnapUtil** (`src/Libs/Snap/SnapUtil.php`) for all input sanitization:

```php
$value = SnapUtil::sanitizeTextInput($_POST['value']);
$int = SnapUtil::sanitizeIntInput($_GET['id']);
```

## Database Queries

**Always use wpdb::prepare()**:

```php
global $wpdb;
$result = $wpdb->get_results($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}duplicator_packages WHERE id = %d",
    $id
));
```

## Nonce Verification

Verify nonces for all forms and AJAX:

```php
check_ajax_referer('duplicator_action', 'nonce');
```

## Capability Checks

Use `CapMng` class for permission management:

```php
CapMng::can(CapMng::CAP_BACKUP);
```

## Output Escaping

Escape all output using WordPress functions:

```php
echo esc_html($user_input);
echo esc_url($url);
echo esc_attr($attribute);
```

## OWASP Top 10

Prevent common vulnerabilities:
- SQL Injection → use `$wpdb->prepare()`
- XSS → escape output
- CSRF → verify nonces
- Command Injection → sanitize inputs
