# Storage System

Storage provider architecture for package destinations.

## Base Architecture

**AbstractStorageEntity** (`src/Models/AbstractStorageEntity.php`) - Base class for all storage providers.

## Storage Types

- **Local** - Default filesystem storage
- **Cloud Providers** (via addons):
  - Amazon S3
  - Dropbox
  - Google Drive
  - FTP/SFTP
  - OneDrive

## Upload Flow

1. Package completes build
2. Upload to configured storage locations
3. Track progress via `UploadInfo` entities
4. Chunked upload for large files

## Adding Storage Providers

Create addon in `addons/` extending `AbstractStorageEntity`.

## Related

- [Package Creation](02_1_PACKAGE_build-process.md)
